function ShowSaveDescriptor(){
	var jpg = false;
	var downloadText = false;
	var _this = this;
	
	function refresh(){
		$("#descriptor").click(function(){
			_this.refreshDescriptor();
		});
	}
	refresh();
	
	this.refreshDescriptor = function(){
		var text = comments("", "\n");
		$("textarea").val(text);
		$("#mainDescriptor").empty();
		text = headerAndBody("<br>");
		$("#mainDescriptor").append(text);
	}
	
	function savePNG(){
		$("#savePNG").click(function(){
			getFileName("Enter image name:", "image");
			jpg = false;
			downloadText = false;
		});
	}
	savePNG();
	
	function saveJPG(){
		$("#saveJPG").click(function(){
			getFileName("Enter image name:", "image");
			jpg = true;
			downloadText = false;
		});
	}
	saveJPG();
	
	function saveFile(){
		$("#save").click(function(){
			getFileName("Enter descriptor name:", "descriptor");
			downloadText = true;
		});	
	}
	saveFile();
	
	function download(){
		$("#downloadImage").click(function(){
			var fileName = $("#fileName").val();
			
			if(downloadText === true){
				var textFile = null;
				var text = comments("# ", "\r\n") + headerAndBody("\r\n");
				
				var data = new Blob([text], {type: 'text/plain'});
				if (textFile !== null) {
				  window.URL.revokeObjectURL(textFile);
				}
				textFile = window.URL.createObjectURL(data);
				$("#downloadImage").attr("href", textFile);
				$("#downloadImage").attr("download", fileName + ".des");
				$("#message").hide();
				return;
			}
			var image = rnaStructure.getImage(jpg);
			$("#downloadImage").attr("href", image);
			if(jpg === true){
				$("#downloadImage").attr("download", fileName + ".jpg");
			}else{
				console.log("png");
				$("#downloadImage").attr("download", fileName + ".png");	
			}
			$("#message").hide();
		});	
	}
	download();
	
	function getFileName(message, defaultName){
		$("#message").show();
		$("#message-content").show();
		$("#message-table").hide();
		$("#message-error").hide();
		$("#messageTitle").text(message);
		$("#fileName").val(defaultName);
	}
	
	function saveComments(){
		$("#SaveCommentsButton").click(function(){
			var result = []; 
			var text = $("textarea").val();
			text = text.split("\n");
			for(var i = 0; i < text.length; i++){
				var line = text[i].trim()
				if(line !== ""){
					result.push(line);
				}
			}
			rnaStructure.setComments(result);
		});	
	}
	saveComments();

	function headerAndBody(newLine){
		var sequences = rnaStructure.getSequences();
		var header = rnaStructure.getHeaderOfDescriptor();
		var result = "";
		result += header.join(" ") + newLine + newLine;
		firstSection = [];
		secondSection = [];
		for(var i=0; i<header.length; i++){
			if(header[i][0] !== "s" && header[i][header[i].length-1] !== "'"){
				firstSection.push(sequences[header[i]]);
			}else if(header[i][0] === "s"){
				secondSection.push(sequences[header[i]]);
			}
		}
		for(var i=0; i < firstSection.length; i++){
			result +=  firstSection[i].repr() + newLine;
		}
		result += newLine;
		for(var i=0; i<secondSection.length; i++){
			result += secondSection[i].repr() + newLine;
		}
		return result;
	}
	
	function comments(hastag, newLine){
		var comments = rnaStructure.getComments();
		var result = "";
		for(var i=0; i<comments.length; i++){
			result += hastag + comments[i] + newLine;
		}
		result += newLine;
		return result;
	}
}